/*
 * regAlloc.h - header file for IA-32 Intel register allocator
 *
 * Actually there is no register allocator. So this module is simply
 * used to track whether a subtree has been encoded or not. This
 * is important for implementing the DUP nodes. This file defines
 * two REG values: 0 (null register) and 1 (subtree visited). Remember
 * that REG is defined in defs.h and is just an int.
 */
#ifndef REGALLOC_H
#define REGALLOC_H

#include "defs.h"

#include "tree.h"

/* initialize a REG to "none" */
#define nullReg() (0)

/* mark tree as visited by the encode phase */
#define setReg() (1)

/* initialize the register allocator: does nothing actually */
extern void initRegAlloc(void);

/* displays a register for debugging purposes. */
extern void printReg(REG r);

#endif
