/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class ShapeFactory {
    final int COLOR = 1;
    final int LINE = 2;
    final int RECT = 3;
    final int OVAL = 4;
    final int FILLRECT = 5;
    final int FILLOVAL = 6;
    final int POLYGON = 8;
    final int POLYLINE = 9;
    final int FILLPOLYGON = 10;
    final int[] encodings = new int[]{0, 8, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private int enc;
    private int[] vals = new int[128];
    private Vector<Integer> inp;

    public ShapeFactory(Vector<Integer> vector) {
        this.inp = vector;
    }

    private int decodeEnc(int[] nArray, int n, int n2, int n3) {
        int n4 = n3 >> 24 & 0xF;
        int n5 = 24;
        int n6 = this.encodings[n2];
        int n7 = (1 << n6) - 1;
        for (int i = 0; i < n4; ++i) {
            nArray[n + i] = n3 >> (n5 -= n6) & n7;
        }
        return n4;
    }

    public Shape createShape() {
        try {
            int n = 0;
            int n2 = 0;
            while (this.enc != 0 || !this.inp.isEmpty()) {
                if (this.enc == 0) {
                    this.enc = this.inp.remove(0);
                }
                int n3 = this.enc >> 28 & 0xF;
                if (n != 0 && n3 != 0) break;
                n2 += this.decodeEnc(this.vals, n2, n | n3, this.enc);
                this.enc = 0;
                if (n3 == 0) continue;
                n = n3;
                if ((n3 & 8) != 0) continue;
                break;
            }
            if (n > 0) {
                SimpleShape simpleShape;
                switch (n) {
                    case 1: {
                        simpleShape = new ColorShape();
                        break;
                    }
                    case 2: {
                        simpleShape = new LineShape();
                        break;
                    }
                    case 3: {
                        simpleShape = new RectShape();
                        break;
                    }
                    case 4: {
                        simpleShape = new OvalShape();
                        break;
                    }
                    case 5: {
                        simpleShape = new FillRectShape();
                        break;
                    }
                    case 6: {
                        simpleShape = new FillOvalShape();
                        break;
                    }
                    case 8: {
                        simpleShape = new PolygonShape();
                        break;
                    }
                    case 9: {
                        simpleShape = new PolylineShape();
                        break;
                    }
                    case 10: {
                        simpleShape = new FillPolygonShape();
                        break;
                    }
                    default: {
                        simpleShape = new UnknownShape();
                    }
                }
                simpleShape.init(this.vals, n2);
                return simpleShape;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

