/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Point;

public class SamplePlayer {
    static int keys = 0;
    static int flares = 0;
    static boolean ladder = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) {
        GameConnection gameConnection = null;
        try {
            byte by;
            if (stringArray.length < 4) {
                System.out.println("usage: java GamePlayer <host> <port> <game> <password>");
                return;
            }
            String string = stringArray[0];
            int n = Integer.parseInt(stringArray[1]);
            String string2 = stringArray[2];
            String string3 = stringArray[3];
            if (n < 0 || n > Short.MAX_VALUE) {
                System.out.println("Port must be between 1 and 32767");
                return;
            }
            gameConnection = new GameConnection(string, n);
            gameConnection.setUpPlayerClient(string2, string3);
            Dimension dimension = gameConnection.getBoardSize();
            GameUpdate gameUpdate = gameConnection.sendMove(new GameMove(0, new Point(0, 0)));
            Point point = gameUpdate.location();
            Dimension dimension2 = gameUpdate.size();
            Point point2 = null;
            Point point3 = null;
            block11: for (int i = 0; i < dimension2.height; ++i) {
                for (int j = 0; j < dimension2.width; ++j) {
                    if (gameUpdate.value(point.x + j, point.y + i) != 2) continue;
                    point2 = new Point(point.x + j, point.y + i);
                    point3 = new Point(point2);
                    continue block11;
                }
            }
            if (point2 == null) {
                System.out.println("Could not locate player position!");
                return;
            }
            Point point4 = new Point(0, 0);
            if (point2.x == 0) {
                point4.x = 1;
            } else if (point2.y == 0) {
                point4.y = 1;
            } else if (point2.x == dimension.width - 1) {
                point4.x = -1;
            } else if (point2.y == dimension.height - 1) {
                point4.y = -1;
            } else if (gameUpdate.value(point2.x + 1, point2.y) == 0) {
                point4.x = 1;
            } else if (gameUpdate.value(point2.x - 1, point2.y) == 0) {
                point4.x = -1;
            } else if (gameUpdate.value(point2.x, point2.y + 1) == 0) {
                point4.y = 1;
            } else if (gameUpdate.value(point2.x, point2.y - 1) == 0) {
                point4.y = -1;
            }
            Point point5 = new Point(0, 0);
            Point point6 = new Point(point2);
            Point point7 = new Point(point5);
            do {
                Thread.currentThread();
                Thread.sleep(50L);
                if (!point2.equals(point3) && (point2.x == 0 || point2.x == dimension.width - 1 || point2.y == 0 || point2.y == dimension.height - 1)) return;
                point5.setLocation(-point4.y, point4.x);
                point7.setLocation(point4);
                if (SamplePlayer.isPassable(gameUpdate.value(point2.x + point5.x, point2.y + point5.y))) {
                    point7.setLocation(point5);
                } else {
                    while (!SamplePlayer.isPassable(gameUpdate.value(point2.x + point7.x, point2.y + point7.y))) {
                        point7.setLocation(point7.y, -point7.x);
                    }
                }
                point6.setLocation(point2);
                point6.translate(point7.x, point7.y);
                by = gameUpdate.value(point6.x, point6.y);
                switch (by) {
                    case 11: {
                        if (!ladder) {
                            ladder = true;
                            break;
                        }
                    }
                    case 0: 
                    case 12: {
                        by = 2;
                        point2.setLocation(point6);
                        point4.setLocation(point7);
                        break;
                    }
                    case 5: {
                        ++keys;
                        break;
                    }
                    case 9: {
                        flares += 2;
                        break;
                    }
                    case 6: 
                    case 7: {
                        by = 5;
                        --keys;
                        break;
                    }
                    case 8: {
                        by = 9;
                        --flares;
                        break;
                    }
                    case 10: {
                        by = 11;
                        ladder = false;
                    }
                }
            } while ((gameUpdate = gameConnection.sendMove(new GameMove(by, point6))).value(point2.x, point2.y) == 2);
            System.out.println("Player in wrong position!");
            return;
        }
        catch (Exception exception) {
            if (gameConnection != null) {
                gameConnection.disconnect();
            }
            System.out.println("Connection broken: " + exception);
        }
    }

    private static boolean isPassable(byte by) {
        switch (by) {
            case 0: 
            case 5: 
            case 9: 
            case 11: 
            case 12: {
                return true;
            }
            case 6: 
            case 7: {
                return keys > 0;
            }
            case 8: {
                return flares > 0;
            }
            case 10: {
                return ladder;
            }
        }
        return false;
    }
}

