/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Point;
import java.util.LinkedList;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;

public class MazeGame
implements Game {
    private final byte NORTH = (byte)8;
    private final byte SOUTH = (byte)4;
    private final byte EAST = (byte)2;
    private final byte WEST = 1;
    private final int OBJ_DENSITY = 128;
    private final int NO_OBJS = 50;
    private final int mazeWidth = 25;
    private final int mazeHeight = 20;
    private final int boardWidth = 51;
    private final int boardHeight = 41;
    private final byte[][] display = new byte[51][41];
    private final BoardCell[][] board = new BoardCell[51][41];
    private final Point curPos = new Point(0, 21);
    private final Random rand = new Random();
    private final ShapeContainer objects = new ShapeContainer();
    private final Dimension udm = new Dimension(0, 0);
    private final Point upt = new Point(0, 0);
    private final Point[] cardinals = new Point[]{new Point(-1, 0), new Point(0, -1), new Point(1, 0), new Point(0, 1)};
    private boolean updateStats = false;
    private boolean hasLadder = false;
    private int numKeys = 0;
    private int numFlares = 0;
    private long seed = this.rand.nextLong() & 0xFFFFFFFFFFFFL;
    private boolean debug = false;
    private int addPasses;

    private int chooseDir(int n) {
        assert (n != 0);
        int n2 = Integer.bitCount(n);
        if (n2 < 2) {
            return n;
        }
        int n3 = this.rand.nextInt(n2);
        for (int i = 0; i < 4; ++i) {
            if ((n >> i & 1) == 0) continue;
            if (n3 == 0) {
                return 1 << i;
            }
            --n3;
        }
        assert (false);
        return 0;
    }

    private byte[][] makeMaze() {
        int n;
        byte[][] byArray = new byte[25][20];
        for (n = 0; n < 25; ++n) {
            byte[] byArray2 = byArray[n];
            byArray2[0] = (byte)(byArray2[0] | 8);
            byte[] byArray3 = byArray[n];
            byArray3[19] = (byte)(byArray3[19] | 4);
        }
        n = 0;
        while (n < 20) {
            byte[] byArray4 = byArray[0];
            int n2 = n;
            byArray4[n2] = (byte)(byArray4[n2] | 1);
            byte[] byArray5 = byArray[24];
            int n3 = n++;
            byArray5[n3] = (byte)(byArray5[n3] | 2);
        }
        Stack<Point> stack = new Stack<Point>();
        stack.push(new Point(12, 10));
        while (!stack.empty()) {
            Point point = (Point)stack.pop();
            int n4 = ~byArray[point.x][point.y] & 0xF;
            if (n4 == 0) continue;
            stack.push(point);
            n4 = this.chooseDir(n4);
            Point point2 = new Point(point.x, point.y);
            int n5 = 0;
            switch (n4) {
                case 2: {
                    ++point2.x;
                    n5 = 1;
                    break;
                }
                case 1: {
                    --point2.x;
                    n5 = 2;
                    break;
                }
                case 8: {
                    n5 = 4;
                    break;
                }
                case 4: {
                    ++point2.y;
                    n5 = 8;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            byte[] byArray6 = byArray[point.x];
            int n6 = point.y;
            byArray6[n6] = (byte)(byArray6[n6] | n4);
            byte[] byArray7 = byArray[point2.x];
            int n7 = --point2.y;
            byArray7[n7] = (byte)(byArray7[n7] | n5);
            if ((byArray[point2.x][point2.y] >> 4 & 0xF) != 0) continue;
            byte[] byArray8 = byArray[point.x];
            int n8 = point.y;
            byArray8[n8] = (byte)(byArray8[n8] | n4 << 4);
            byte[] byArray9 = byArray[point2.x];
            int n9 = point2.y;
            byArray9[n9] = (byte)(byArray9[n9] | n5 << 4);
            stack.push(point2);
        }
        byte[] byArray10 = byArray[0];
        byArray10[10] = (byte)(byArray10[10] | 0x10);
        byte[] byArray11 = byArray[24];
        byArray11[10] = (byte)(byArray11[10] | 0x20);
        return byArray;
    }

    private void addOccupier(Point point, BoardCell boardCell) {
        this.board[point.x][point.y].setOccupier(boardCell);
        this.display[point.x][point.y] = this.board[point.x][point.y].ID();
    }

    private boolean isHorizontal(Point point) {
        return !this.board[point.x][point.y - 1].isPassable() && !this.board[point.x][point.y + 1].isPassable();
    }

    private boolean isVertical(Point point) {
        return !this.board[point.x - 1][point.y].isPassable() && !this.board[point.x + 1][point.y].isPassable();
    }

    private void placeObstacles() {
        int n = 50;
        int n2 = 128;
        BoardCell boardCell = null;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        LinkedList<Point> linkedList = new LinkedList<Point>();
        this.board[this.curPos.x][this.curPos.y].setVisited(true);
        this.board[this.curPos.x + 1][this.curPos.y].setVisited(true);
        linkedList.offer(new Point(this.curPos.x + 1, this.curPos.y));
        while (!linkedList.isEmpty()) {
            Point point = (Point)linkedList.poll();
            for (Point point2 : this.cardinals) {
                Point point3 = new Point(point.x + point2.x, point.y + point2.y);
                if (point3.x >= 50 || !this.board[point3.x][point3.y].isPassable() || this.board[point3.x][point3.y].isVisited()) continue;
                linkedList.offer(point3);
                this.board[point3.x][point3.y].setVisited(true);
            }
            if (n == 0) {
                n2 = this.rand.nextInt(128);
            }
            if (n2 < 1) {
                if (n == 0) {
                    bl = true;
                    boardCell = new BoardItem(5);
                    ++n3;
                    n = 2;
                } else if (this.isVertical(point)) {
                    ++n6;
                    boardCell = new BoardObstacle(7);
                } else if (this.isHorizontal(point)) {
                    boardCell = new BoardObstacle(6);
                    ++n6;
                } else {
                    ++n;
                }
            } else if (n2 < 3) {
                if (n == 0) {
                    boardCell = new BoardItem(11);
                    ++n4;
                    n = 2;
                } else if (this.isHorizontal(point)) {
                    boardCell = new BoardObstacle(10);
                    ++n8;
                } else {
                    ++n;
                }
            } else if (n2 < 7) {
                if (n == 0) {
                    boardCell = new BoardItem(9);
                    ++n5;
                    n = 3;
                } else {
                    boardCell = new BoardObstacle(8);
                    ++n7;
                }
            }
            if (n <= 0) continue;
            if (boardCell != null) {
                this.addOccupier(point, boardCell);
                boardCell = null;
            }
            --n;
        }
        this.resetVisited();
        if (this.debug) {
            System.out.println("Zombies: " + n7 + ", Flares: " + n5);
            System.out.println("Doors: " + n6 + ", Keys: " + n3);
            System.out.println("Tarpits: " + n8 + ", Ladders: " + n4);
        }
    }

    private void resetVisited() {
        for (int i = 0; i < 51; ++i) {
            for (int j = 0; j < 41; ++j) {
                this.board[i][j].setVisited(false);
            }
        }
    }

    private boolean isWall(byte by) {
        return by == 1 || by == 3;
    }

    private void checkObstacle(byte by, byte by2, byte by3, int n) {
        Stack<Point> stack = new Stack<Point>();
        this.board[this.curPos.x][this.curPos.y].setVisited(true);
        this.board[this.curPos.x + 1][this.curPos.y].setVisited(true);
        this.addPasses = 0;
        this.sweepPasses(new Point(this.curPos.x + 1, this.curPos.y), stack, by, by2, by3, n);
        if (this.debug) {
            System.out.println("Adding " + this.addPasses + " of type " + by);
        }
        this.resetVisited();
    }

    private void sweepPasses(Point point, Stack<Point> stack, byte by, byte by2, byte by3, int n) {
        int n2 = 0;
        int n3 = stack.size();
        LinkedList<Point> linkedList = new LinkedList<Point>();
        boolean bl = true;
        if (this.board[point.x][point.y].ID() == by) {
            ++n2;
        }
        linkedList.offer(point);
        while (!linkedList.isEmpty()) {
            Point point2 = (Point)linkedList.poll();
            for (Point point3 : this.cardinals) {
                Point point4 = new Point(point2.x + point3.x, point2.y + point3.y);
                if (point4.x >= 50 || this.board[point4.x][point4.y].isVisited()) continue;
                this.board[point4.x][point4.y].setVisited(true);
                byte by4 = this.board[point4.x][point4.y].ID();
                if (this.isWall(by4)) continue;
                if (by4 == by2 || by4 == by3) {
                    n2 -= this.sweepObsts(point4, stack, by, by2, by3, n);
                    continue;
                }
                linkedList.offer(point4);
                if (by4 == by) {
                    n2 += n;
                    continue;
                }
                if (!this.board[point4.x][point4.y].isPassable()) {
                    bl = false;
                    continue;
                }
                if (!bl || by4 != 0) continue;
                stack.push(point4);
            }
        }
        while (n2 < 0 && !stack.isEmpty()) {
            this.addOccupier(stack.pop(), new BoardItem(by));
            n2 += n;
            ++this.addPasses;
        }
        for (int i = stack.size(); i > n3; --i) {
            stack.pop();
        }
    }

    private int sweepObsts(Point point, Stack<Point> stack, byte by, byte by2, byte by3, int n) {
        int n2 = 1;
        LinkedList<Point> linkedList = new LinkedList<Point>();
        linkedList.offer(point);
        while (!linkedList.isEmpty()) {
            Point point2 = (Point)linkedList.poll();
            for (Point point3 : this.cardinals) {
                Point point4 = new Point(point2.x + point3.x, point2.y + point3.y);
                if (point4.x >= 50 || this.board[point4.x][point4.y].isVisited()) continue;
                this.board[point4.x][point4.y].setVisited(true);
                byte by4 = this.board[point4.x][point4.y].ID();
                if (this.isWall(by4)) continue;
                if (by4 == by) {
                    this.sweepPasses(point4, stack, by, by2, by3, n);
                    continue;
                }
                linkedList.offer(point4);
                if (by4 != by2 && by4 != by3) continue;
                ++n2;
            }
        }
        return n2;
    }

    public void makeBoard() {
        int n;
        int n2;
        byte[][] byArray = this.makeMaze();
        for (n2 = 0; n2 < 20; ++n2) {
            for (n = 0; n < 25; ++n) {
                int n3 = 2 * n + 1;
                int n4 = 2 * n2 + 1;
                for (int i = -1; i < 2; ++i) {
                    byte[] byArray2 = this.display[n3 + i];
                    int n5 = n4 - 1;
                    byArray2[n5] = (byte)(byArray2[n5] | ~byArray[n][n2] >> 4 & 8);
                    byte[] byArray3 = this.display[n3 + i];
                    int n6 = n4 + 1;
                    byArray3[n6] = (byte)(byArray3[n6] | ~byArray[n][n2] >> 4 & 4);
                    byte[] byArray4 = this.display[n3 - 1];
                    int n7 = n4 + i;
                    byArray4[n7] = (byte)(byArray4[n7] | ~byArray[n][n2] >> 4 & 1);
                    byte[] byArray5 = this.display[n3 + 1];
                    int n8 = n4 + i;
                    byArray5[n8] = (byte)(byArray5[n8] | ~byArray[n][n2] >> 4 & 2);
                }
            }
        }
        for (n2 = 0; n2 < 51; ++n2) {
            for (n = 0; n < 41; ++n) {
                if (this.display[n2][n] != 0) {
                    this.display[n2][n] = 1;
                    this.board[n2][n] = new BoardWall(1, 3);
                    continue;
                }
                this.board[n2][n] = new BoardWay(0, 0);
            }
        }
        this.display[this.curPos.x][this.curPos.y] = 2;
        this.board[this.curPos.x][this.curPos.y].setOccupier(new BoardPlayer(2));
        this.placeObstacles();
        this.checkObstacle((byte)9, (byte)8, (byte)8, 2);
        this.checkObstacle((byte)11, (byte)10, (byte)10, 1);
        this.checkObstacle((byte)5, (byte)7, (byte)6, 1);
        this.computeVisited(this.curPos);
    }

    @Override
    public void init(String[] stringArray, boolean bl) {
        block3: {
            this.debug = bl;
            try {
                this.objects.addShapes("maze.obj");
                if (stringArray.length > 1) {
                    this.seed = Long.parseLong(stringArray[1]);
                }
            }
            catch (Exception exception) {
                if (!this.debug) break block3;
                System.err.println(exception.toString());
            }
        }
        this.rand.setSeed(this.seed);
        this.makeBoard();
        this.upt.x = 0;
        this.upt.y = 0;
        this.udm.width = 51;
        this.udm.height = 41;
    }

    @Override
    public Dimension boardSize() {
        return new Dimension(51, 41);
    }

    @Override
    public Vector<EncodedShape> getObjects() {
        return this.objects.getShapes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GameUpdate viewUpdate(boolean bl) {
        ViewUpdate viewUpdate = null;
        String string = null;
        byte[][] byArray = this.display;
        synchronized (this.display) {
            if (bl) {
                this.upt.x = 0;
                this.upt.y = 0;
                this.udm.width = 51;
                this.udm.height = 41;
            }
            if (this.seed >= 0L) {
                string = "Board #" + this.seed;
                this.seed = -1L;
            } else if (this.updateStats) {
                this.updateStats = false;
                string = "Keys:" + this.numKeys + ", Flares:" + (float)this.numFlares / 2.0f + ", Ladder:" + this.hasLadder;
            }
            if (this.udm.width > 0) {
                viewUpdate = new ViewUpdate(this.display, new Point(this.upt), new Dimension(this.udm), string);
            }
            this.udm.width = 0;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return viewUpdate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GameUpdate nextMove(GameMove gameMove) {
        ViewUpdate viewUpdate = null;
        byte[][] byArray = this.display;
        synchronized (this.display) {
            Point point = gameMove.location();
            if (this.validPos(point)) {
                byte by = this.board[point.x][point.y].ID();
                switch (gameMove.value()) {
                    case 2: {
                        if (!this.board[point.x][point.y].isPassable()) break;
                        this.computeUpdate(this.curPos);
                        this.computeUpdate(point);
                        this.addOccupier(point, this.board[this.curPos.x][this.curPos.y].getOccupier());
                        this.computeVisited(point);
                        this.addOccupier(this.curPos, null);
                        this.curPos.setLocation(point);
                        break;
                    }
                    case 11: {
                        if (by == 11 && !this.hasLadder) {
                            this.hasLadder = true;
                            this.updateStats = true;
                            this.addOccupier(point, null);
                            this.computeUpdate(point);
                            break;
                        }
                        if (by != 10 || !this.hasLadder) break;
                        this.hasLadder = false;
                        this.updateStats = true;
                        this.addOccupier(point, null);
                        this.addOccupier(point, new BoardItem(12));
                        this.computeUpdate(point);
                        break;
                    }
                    case 5: {
                        if (by == 5) {
                            ++this.numKeys;
                            this.updateStats = true;
                            this.addOccupier(point, null);
                            this.computeUpdate(point);
                            break;
                        }
                        if (by != 7 && by != 6 || this.numKeys <= 0) break;
                        --this.numKeys;
                        this.updateStats = true;
                        this.addOccupier(point, null);
                        this.computeUpdate(point);
                        break;
                    }
                    case 9: {
                        if (by == 9) {
                            this.numFlares += 2;
                            this.updateStats = true;
                            this.addOccupier(point, null);
                            this.computeUpdate(point);
                            break;
                        }
                        if (by != 8 || this.numFlares <= 0) break;
                        --this.numFlares;
                        this.updateStats = true;
                        this.addOccupier(point, null);
                        this.computeUpdate(point);
                    }
                }
            }
            point.setLocation(this.curPos.x - 1, this.curPos.y - 1);
            Dimension dimension = new Dimension(3, 3);
            this.adjustUpdate(point, dimension);
            viewUpdate = new ViewUpdate(this.display, point, dimension);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return viewUpdate;
        }
    }

    private boolean validPos(Point point) {
        return point.x >= 0 && point.y >= 0 && point.x < 51 && point.y < 41 && Math.abs(point.x - this.curPos.x) <= 1 && Math.abs(point.x - this.curPos.x) <= 1;
    }

    private void adjustUpdate(Point point, Dimension dimension) {
        if (point.x < 0) {
            dimension.width -= -point.x;
            point.x = 0;
        }
        if (point.y < 0) {
            dimension.height -= -point.y;
            point.y = 0;
        }
        dimension.width = Math.min(dimension.width, 51 - point.x);
        dimension.height = Math.min(dimension.height, 41 - point.y);
    }

    private void computeVisited(Point point) {
        Point point2 = new Point();
        point2.x = point.x - 1;
        while (point2.x <= point.x + 1) {
            point2.y = point.y - 1;
            while (point2.y <= point.y + 1) {
                if (point2.x >= 0 && point2.x < 51 && point2.y >= 0 && point2.y < 41 && !this.board[point2.x][point2.y].isVisited()) {
                    this.board[point2.x][point2.y].setVisited(true);
                    this.computeUpdate(point2);
                    this.display[point2.x][point2.y] = this.board[point2.x][point2.y].ID();
                }
                ++point2.y;
            }
            ++point2.x;
        }
    }

    private void computeUpdate(Point point) {
        if (this.udm.width == 0) {
            this.upt.setLocation(point);
            this.udm.setSize(1, 1);
        } else {
            if (point.x < this.upt.x) {
                this.udm.width += this.upt.x - point.x;
                this.upt.x = point.x;
            }
            if (point.y < this.upt.y) {
                this.udm.height += this.upt.y - point.y;
                this.upt.y = point.y;
            }
            if (point.x >= this.upt.x + this.udm.width) {
                this.udm.width += point.x - (this.upt.x + this.udm.width) + 1;
            }
            if (point.y >= this.upt.y + this.udm.height) {
                this.udm.height += point.y - (this.upt.y + this.udm.height) + 1;
            }
        }
    }
}

