/*
 * Decompiled with CFR 0.152.
 */
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;

public class GameServer {
    static final int DEFAULT_PORT = 4242;
    static boolean debug = false;

    public static void main(String[] stringArray) {
        try {
            int n = 4242;
            for (String string : stringArray) {
                if (string.equals("-d")) {
                    debug = true;
                    continue;
                }
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    System.out.println("Unexpected argument: " + string);
                    System.out.println("Usage: java GameServer [port #] [-d]");
                }
            }
            ServerSocket serverSocket = new ServerSocket(n);
            while (true) {
                Thread thread = new Thread(new ConnectionThread(serverSocket.accept()));
                thread.start();
            }
        }
        catch (Exception exception) {
            if (debug) {
                System.out.println(exception);
            }
            return;
        }
    }

    private static class ConnectionThread
    implements Runnable {
        private GameConnection con;
        private Socket sock;

        ConnectionThread(Socket socket) {
            this.sock = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void viewer(Game game) {
            try {
                this.con.setUpViewerServer(game.boardSize(), game.getObjects());
                boolean bl = true;
                this.con.sendUpdate(game.viewUpdate(true));
                while (true) {
                    GameUpdate gameUpdate;
                    if ((gameUpdate = game.viewUpdate(false)) == null) {
                        Game game2 = game;
                        synchronized (game2) {
                            game.wait(500L);
                        }
                        gameUpdate = game.viewUpdate(false);
                        if (gameUpdate == null) {
                            gameUpdate = new ViewUpdate();
                        }
                    }
                    this.con.sendUpdate(gameUpdate);
                }
            }
            catch (Exception exception) {
                if (debug) {
                    System.out.println("Viewer Connection: " + exception.toString());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void player(Game game) {
            block8: {
                if (game != null) {
                    try {
                        this.con.setUpPlayerServer(game.boardSize());
                        while (true) {
                            GameUpdate gameUpdate;
                            if ((gameUpdate = game.nextMove(this.con.recvMove())) == null) {
                                continue;
                            }
                            Game game2 = game;
                            synchronized (game2) {
                                game.notify();
                            }
                            this.con.sendUpdate(gameUpdate);
                        }
                    }
                    catch (Exception exception) {
                        if (!debug) break block8;
                        System.out.println("Player Connection: " + exception.toString());
                        exception.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void run() {
            block7: {
                try {
                    this.con = new GameConnection(this.sock);
                    String string = this.con.initSetupServer();
                    String string2 = this.con.getGame();
                    String string3 = this.con.getPassword();
                    ActiveGame activeGame = ActiveGame.findGame(string2, string3);
                    if (string.equals("viewer")) {
                        if (activeGame != null && !activeGame.viewerAttached()) {
                            activeGame.attachViewer(this.con);
                            this.viewer(activeGame.getGame());
                            activeGame.detachViewer();
                        }
                    } else if (string.equals("player")) {
                        if (activeGame != null) {
                            this.con.disconnect();
                            return;
                        }
                        Game game = GameFactory.createGame(string2, debug);
                        activeGame = new ActiveGame(game, string2, string3, this.con);
                        this.player(game);
                        activeGame.deactivate();
                    }
                    this.con.disconnect();
                }
                catch (Exception exception) {
                    this.con.disconnect();
                    if (!debug) break block7;
                    System.out.println(exception);
                }
            }
        }
    }

    private static class ActiveGame {
        private static Hashtable<String, ActiveGame> games = new Hashtable();
        private Game game;
        private GameConnection playerConn;
        private GameConnection viewerConn;
        private Thread playerThread;
        private Thread viewerThread;
        private String password;
        private String name;
        private String key;

        public ActiveGame(Game game, String string, String string2, GameConnection gameConnection) {
            this.game = game;
            this.name = string;
            this.key = ActiveGame.makeKey(string, string2);
            this.password = string2;
            this.playerConn = gameConnection;
            this.playerThread = Thread.currentThread();
            games.put(this.key, this);
        }

        private static String makeKey(String string, String string2) {
            return string + " " + string2;
        }

        public static ActiveGame findGame(String string, String string2) {
            return games.get(ActiveGame.makeKey(string, string2));
        }

        public Game getGame() {
            return this.game;
        }

        public boolean viewerAttached() {
            return this.viewerConn != null;
        }

        public void attachViewer(GameConnection gameConnection) {
            this.viewerConn = gameConnection;
            this.viewerThread = Thread.currentThread();
        }

        public void detachViewer() {
            this.viewerConn = null;
            this.viewerThread = null;
        }

        public synchronized void deactivate() {
            if (this.viewerConn != null) {
                this.viewerConn.disconnect();
                this.viewerConn = null;
            }
            if (this.viewerThread != null) {
                this.viewerThread.interrupt();
                this.viewerThread = null;
            }
            if (this.playerConn != null) {
                this.playerConn.disconnect();
                this.playerConn = null;
            }
            games.remove(this.key);
        }
    }
}

