/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Scanner;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class GameViewerApplet
extends JApplet {
    private GameViewer gv;
    private JTextField host;
    private JTextField port;
    private JTextField pass;
    private JTextField game;
    private JButton doCon;
    private JLabel status;
    private JTextArea log;

    @Override
    public void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.gv = new GameViewer();
        this.gv.setBorder(LineBorder.createBlackLineBorder());
        this.add((Component)this.gv, "Center");
        Dimension dimension = this.gv.getPreferredSize();
        this.add((Component)jPanel, "East");
        jPanel.add((Component)jPanel2, "North");
        this.log = new JTextArea("Log Area\n");
        jPanel.add(new JScrollPane(this.log));
        this.log.setLineWrap(true);
        this.log.setEditable(false);
        jPanel.setBorder(LineBorder.createBlackLineBorder());
        jPanel = jPanel2;
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(LineBorder.createBlackLineBorder());
        jPanel2 = new JPanel(new BorderLayout());
        jPanel.add(jPanel2);
        jPanel2.add((Component)new JLabel(" Host:"), "West");
        this.host = new JTextField("localhost", 20);
        jPanel2.add((Component)this.host, "Center");
        jPanel2 = new JPanel(new BorderLayout());
        jPanel.add(jPanel2);
        jPanel2.add((Component)new JLabel(" Port:"), "West");
        this.port = new JTextField("4242", 7);
        jPanel2.add((Component)this.port, "Center");
        jPanel2 = new JPanel(new BorderLayout());
        jPanel.add(jPanel2);
        jPanel2.add((Component)new JLabel(" Game:"), "West");
        this.game = new JTextField("Maze", 10);
        jPanel2.add((Component)this.game, "Center");
        jPanel2 = new JPanel(new BorderLayout());
        jPanel.add(jPanel2);
        jPanel2.add((Component)new JLabel(" Password:"), "West");
        this.pass = new JTextField(10);
        jPanel2.add((Component)this.pass, "Center");
        jPanel2 = new JPanel(new BorderLayout());
        jPanel.add(jPanel2);
        this.doCon = new JButton("Connect");
        this.doCon.addActionListener(new ButtonListener());
        jPanel2.add((Component)this.doCon, "Center");
        jPanel2 = new JPanel(new FlowLayout());
        jPanel.add(jPanel2);
        jPanel2.add(new JLabel("Status: "));
        this.status = new JLabel("Not Connected");
        jPanel2.add(this.status);
        this.resize(dimension.height + 400, dimension.height + 40);
        new Logger().start();
        System.out.println("Logger enabled");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Jumbled Image");
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        GameViewerApplet gameViewerApplet = new GameViewerApplet();
        gameViewerApplet.init();
        jFrame.add("Center", gameViewerApplet);
        jFrame.pack();
        jFrame.setVisible(true);
        while (true) {
            try {
                while (true) {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private class Updater
    extends Thread {
        private GameConnection conn;
        private boolean dead = false;

        private Updater() {
        }

        @Override
        public void run() {
            String string = GameViewerApplet.this.host.getText();
            int n = 0;
            String string2 = GameViewerApplet.this.pass.getText();
            String string3 = GameViewerApplet.this.game.getText();
            try {
                n = Integer.parseInt(GameViewerApplet.this.port.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n < 1 || n > Short.MAX_VALUE) {
                GameViewerApplet.this.status.setText("Invalid port #");
                return;
            }
            if (string2.length() < 8) {
                GameViewerApplet.this.status.setText("Password too short");
                return;
            }
            if (string3.length() < 1) {
                GameViewerApplet.this.status.setText("No game entered");
                return;
            }
            if (string2.matches("\\s")) {
                GameViewerApplet.this.status.setText("Password contains whitespace");
                return;
            }
            if (string3.matches("\\s")) {
                GameViewerApplet.this.status.setText("Game contains whitespace");
                return;
            }
            boolean bl = false;
            while (true) {
                try {
                    block5: while (true) {
                        Object object;
                        Cloneable cloneable;
                        GameConnection gameConnection;
                        GameViewerApplet.this.doCon.setText("Disconnect");
                        if (bl) {
                            GameViewerApplet.this.status.setText("Pausing");
                            Updater.sleep(1000L);
                        }
                        bl = true;
                        GameViewerApplet.this.status.setText("Connecting");
                        this.conn = gameConnection = new GameConnection(string, n);
                        GameViewerApplet.this.status.setText("Connected");
                        gameConnection.setUpViewerClient(string3, string2);
                        Dimension dimension = gameConnection.getBoardSize();
                        GameViewerApplet.this.gv.resetBoard(dimension.width, dimension.height);
                        GameViewerApplet.this.gv.resetShapes();
                        Dimension dimension2 = GameViewerApplet.this.doCon.getSize();
                        Dimension dimension3 = GameViewerApplet.this.gv.getPreferredSize();
                        GameViewerApplet.this.resize(dimension2.width + dimension3.width + 10, dimension3.height + 40);
                        GameViewerApplet.this.log.append("Board size: " + dimension.width + " x " + dimension.height + "\n");
                        bl = false;
                        Vector<EncodedShape> vector = gameConnection.getObjects();
                        for (EncodedShape encodedShape : vector) {
                            cloneable = new Vector();
                            object = new ShapeFactory(encodedShape.getEncoding());
                            Shape shape = ((ShapeFactory)object).createShape();
                            while (shape != null) {
                                ((Vector)cloneable).add(shape);
                                shape = ((ShapeFactory)object).createShape();
                            }
                            GameViewerApplet.this.gv.setShape(encodedShape.getID(), (Vector<Shape>)cloneable);
                        }
                        while (true) {
                            if (this.conn == null) continue block5;
                            GameUpdate gameUpdate = gameConnection.recvUpdate();
                            Point point = gameUpdate.location();
                            cloneable = gameUpdate.size();
                            object = gameUpdate.msg();
                            if (point != null && cloneable != null) {
                                for (int i = 0; i < ((Dimension)cloneable).height; ++i) {
                                    for (int j = 0; j < ((Dimension)cloneable).width; ++j) {
                                        GameViewerApplet.this.gv.setBoard(gameUpdate.value(point.x + j, point.y + i), point.x + j, point.y + i);
                                    }
                                }
                                GameViewerApplet.this.gv.repaint();
                            }
                            if (object == null) continue;
                            GameViewerApplet.this.log.append("Msg: " + (String)object + "\n");
                            GameViewerApplet.this.log.setCaretPosition(GameViewerApplet.this.log.getDocument().getLength());
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    if (!this.dead) {
                        if (this.conn == null) continue;
                        this.conn.disconnect();
                        continue;
                    }
                    return;
                }
                break;
            }
        }

        private void disconnect() {
            if (!this.dead) {
                this.dead = true;
                this.interrupt();
                if (this.conn != null) {
                    this.conn.disconnect();
                    this.conn = null;
                }
                GameViewerApplet.this.status.setText("Not Connected");
                GameViewerApplet.this.doCon.setText("Connect");
            }
        }

        public boolean isDead() {
            return this.dead;
        }
    }

    private class Logger
    extends Thread {
        Scanner sc;

        public Logger() {
            try {
                PipedInputStream pipedInputStream = new PipedInputStream();
                System.setOut(new PrintStream(new PipedOutputStream(pipedInputStream), true));
                this.sc = new Scanner(pipedInputStream);
            }
            catch (Exception exception) {
                GameViewerApplet.this.log.append("Logger failed to initialize: " + exception.toString() + "\n");
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    GameViewerApplet.this.log.append(this.sc.nextLine() + "\n");
                    GameViewerApplet.this.log.setCaretPosition(GameViewerApplet.this.log.getDocument().getLength());
                }
            }
            catch (Exception exception) {
                GameViewerApplet.this.log.append("Logger died: " + exception.toString() + "\n");
                return;
            }
        }
    }

    private class ButtonListener
    implements ActionListener {
        private Updater updater;

        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.updater != null && this.updater.isAlive() && !this.updater.isDead()) {
                this.updater.disconnect();
            } else {
                this.updater = new Updater();
                this.updater.start();
            }
        }
    }
}

