/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Point;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Scanner;
import java.util.Vector;

public class GameConnection {
    public final String VER = "1.0";
    private Socket sock;
    private PrintStream out;
    private Scanner in;
    private String pass;
    private String game;
    private boolean setupDone;
    private Dimension dim;
    private byte[][] board;
    private Vector<EncodedShape> objs;

    public GameConnection(String string, int n) throws Exception {
        this.sock = new Socket(string, n);
        this.in = new Scanner(this.sock.getInputStream());
        this.out = new PrintStream(this.sock.getOutputStream(), true);
    }

    public GameConnection(Socket socket) throws Exception {
        this.sock = socket;
        this.in = new Scanner(this.sock.getInputStream());
        this.out = new PrintStream(this.sock.getOutputStream(), true);
    }

    public String initSetupServer() throws Exception {
        if (this.setupDone) {
            throw new AlreadySetUpException();
        }
        String string = this.in.next();
        String string2 = this.in.next();
        this.game = this.in.next();
        this.pass = this.in.next();
        return string2;
    }

    public String getPassword() throws Exception {
        if (this.pass == null) {
            throw new NotSetUpException();
        }
        return this.pass;
    }

    public String getGame() throws Exception {
        if (this.game == null) {
            throw new NotSetUpException();
        }
        return this.game;
    }

    public void setUpPlayerServer(Dimension dimension) throws Exception {
        if (this.setupDone) {
            throw new AlreadySetUpException();
        }
        this.dim = dimension;
        this.out.println("1.0 board " + dimension.width + " " + dimension.height);
        this.in.next();
        this.setupDone = true;
    }

    public void setUpPlayerClient(String string, String string2) throws Exception {
        if (this.setupDone) {
            throw new AlreadySetUpException();
        }
        this.pass = string2;
        this.out.println("1.0 player " + string + " " + this.pass);
        String string3 = this.in.next();
        String string4 = this.in.next();
        int n = this.in.nextInt();
        int n2 = this.in.nextInt();
        this.dim = new Dimension(n, n2);
        this.board = new byte[n][n2];
        this.out.println("OK");
        this.setupDone = true;
    }

    public void setUpViewerServer(Dimension dimension, Vector<EncodedShape> vector) throws Exception {
        if (this.setupDone) {
            throw new AlreadySetUpException();
        }
        this.out.println("1.0 board " + dimension.width + " " + dimension.height);
        for (EncodedShape encodedShape : vector) {
            String string = encodedShape.getID() + "";
            Vector<Integer> vector2 = encodedShape.getEncoding();
            for (Integer n : vector2) {
                string = string + " " + n;
            }
            this.out.println(string);
        }
        this.out.println("0");
        this.in.next();
        this.setupDone = true;
    }

    public void setUpViewerClient(String string, String string2) throws Exception {
        if (this.setupDone) {
            throw new AlreadySetUpException();
        }
        this.pass = string2;
        this.objs = new Vector();
        this.out.println("1.0 viewer " + string + " " + this.pass);
        String string3 = this.in.next();
        String string4 = this.in.next();
        int n = this.in.nextInt();
        int n2 = this.in.nextInt();
        this.dim = new Dimension(n, n2);
        this.board = new byte[n][n2];
        int n3 = this.in.nextInt();
        while (n3 > 0) {
            EncodedShape encodedShape = new EncodedShape(n3);
            this.objs.add(encodedShape);
            Scanner scanner = new Scanner(this.in.nextLine());
            while (scanner.hasNextLong()) {
                encodedShape.add(new Integer((int)scanner.nextLong()));
            }
            n3 = this.in.nextInt();
        }
        this.out.println("OK");
        this.setupDone = true;
    }

    public Dimension getBoardSize() throws Exception {
        if (!this.setupDone) {
            throw new NotSetUpException();
        }
        return this.dim;
    }

    public Vector<EncodedShape> getObjects() throws Exception {
        if (!this.setupDone) {
            throw new NotSetUpException();
        }
        return this.objs;
    }

    public void sendUpdate(GameUpdate gameUpdate) throws Exception {
        if (!this.setupDone) {
            throw new NotSetUpException();
        }
        Point point = gameUpdate.location();
        Dimension dimension = gameUpdate.size();
        String string = gameUpdate.msg();
        if (dimension != null && dimension.width > 0 && dimension.height > 0) {
            String string2 = "1.0 update " + point.x + " " + point.y + " " + dimension.width + " " + dimension.height;
            for (int i = 0; i < dimension.height; ++i) {
                for (int j = 0; j < dimension.width; ++j) {
                    string2 = string2 + " " + gameUpdate.value(point.x + j, point.y + i);
                }
            }
            this.out.println(string2);
            this.in.next();
        }
        if (string != null) {
            this.out.println("1.0 message " + string);
            this.in.next();
        } else if (dimension == null) {
            this.out.println("1.0 heartbeat");
            this.in.next();
        }
    }

    public GameUpdate recvUpdate() throws Exception {
        if (!this.setupDone) {
            throw new NotSetUpException();
        }
        Point point = new Point();
        Dimension dimension = new Dimension();
        String string = this.in.next();
        String string2 = this.in.next();
        ViewUpdate viewUpdate = null;
        if (string2.equals("update")) {
            point.x = this.in.nextInt();
            point.y = this.in.nextInt();
            dimension.width = this.in.nextInt();
            dimension.height = this.in.nextInt();
            for (int i = 0; i < dimension.height; ++i) {
                for (int j = 0; j < dimension.width; ++j) {
                    this.board[point.x + j][point.y + i] = this.in.nextByte();
                }
            }
            viewUpdate = new ViewUpdate(this.board, point, dimension);
        } else if (string2.equals("message")) {
            viewUpdate = new ViewUpdate(this.in.nextLine());
        } else if (string2.equals("heartbeat")) {
            viewUpdate = new ViewUpdate();
        } else {
            throw new ProtocolException();
        }
        this.out.println("OK");
        return viewUpdate;
    }

    public GameUpdate sendMove(GameMove gameMove) throws Exception {
        if (!this.setupDone) {
            throw new NotSetUpException();
        }
        Point point = gameMove.location();
        this.out.println("1.0 move " + gameMove.value() + " " + point.x + " " + point.y);
        this.in.next();
        return this.recvUpdate();
    }

    public GameMove recvMove() throws Exception {
        if (!this.setupDone) {
            throw new NotSetUpException();
        }
        String string = this.in.next();
        String string2 = this.in.next();
        if (!string2.equals("move")) {
            throw new ProtocolException();
        }
        byte by = (byte)this.in.nextInt();
        Point point = new Point();
        point.x = this.in.nextInt();
        point.y = this.in.nextInt();
        this.out.println("OK");
        return new GameMove(by, point);
    }

    public void disconnect() {
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sock = null;
        }
    }

    private class ProtocolException
    extends Exception {
        private ProtocolException() {
        }

        @Override
        public String toString() {
            return "Unexpected token in protocol";
        }
    }

    private class NotSetUpException
    extends Exception {
        private NotSetUpException() {
        }

        @Override
        public String toString() {
            return "Not Set Up";
        }
    }

    private class AlreadySetUpException
    extends Exception {
        private AlreadySetUpException() {
        }

        @Override
        public String toString() {
            return "Already set up";
        }
    }
}

